
# The Black Star File System

The Black Star File System (BSFS) is a semantic file system, meaning that it organizes files
by association, and can record files, their metadata and content in a structured manner.


## Installation

You can install BSFS via pip:

    $ pip install --extra-index-url https://pip.bsfs.io bsfs


## Development

Set up a virtual environment:

    $ virtualenv env
    $ source env/bin/activate

Install bsfs as editable from the git repository:

    $ git clone https://git.bsfs.io/bsfs.git
    $ cd bsfs
    $ pip install -e .

If you want to develop (*dev*), run the tests (*test*), edit the 
documentation (*doc*), or build a distributable (*build*),
install bsfs with the respective extras:

    $ pip install -e .[dev,doc,build,test]

Or, you can manually install the following packages besides BSFS:

    $ pip install coverage mypy pylint
    $ pip install sphinx sphinx-copybutton furo
    $ pip install build

To ensure code style discipline, run the following commands:

    $ coverage run ; coverage html ; xdg-open .htmlcov/index.html
    $ pylint bsfs
    $ mypy

To build the package, do:

    $ python -m build

To run only the tests (without coverage), run the following command from the **test folder**:

    $ python -m unittest

To build the documentation, run the following commands from the **doc folder**:

    $ sphinx-apidoc -f -o source/api ../bsfs/ --module-first -d 1 --separate
    $ make html
    $ xdg-open build/html/index.html

