#!/usr/bin/env python3

# imports
import argparse
import typing

# bsfs imports
import bsfs

# inner-module imports
from .init import main as init
from .migrate import main as migrate

# exports
__all__: typing.Sequence[str] = (
    'main',
    'init',
    'migrate',
    )

# config
apps = {
    'init'      : init,
    'migrate'   : migrate,
    }


## code ##

def main(argv=None):
    """Black Star File System maintenance tools."""
    parser = argparse.ArgumentParser(description=main.__doc__, prog='bsfs')
    # version
    parser.add_argument('--version', action='version',
        version='%(prog)s version {}.{}.{}'.format(*bsfs.version_info)) # pylint: disable=C0209
    # application selection
    parser.add_argument('app', choices=apps.keys(),
        help='Select the application to run.')
    # dangling args
    parser.add_argument('rest', nargs=argparse.REMAINDER)
    # parse
    args = parser.parse_args(argv)
    # run application
    apps[args.app](args.rest)


## main ##

if __name__ == '__main__':
    import sys
    main(sys.argv[1:])

## EOF ##
