#!/usr/bin/env python3

# imports
import argparse
import json
import sys
import typing

# bsfs imports
from bsfs.utils import errors

# exports
__all__: typing.Sequence[str] = (
    'main',
    )

## code ##

def init_sparql_store(user) -> typing.Any:
    """Initialize a SparqlStore backend. Returns a configuration to load it."""
    # nothing to do for non-persistent store
    # return config to storage
    return {
        'Graph': {
            'user': user,
            'backend': {
                'SparqlStore': {},
                },
            }
        }


def main(argv):
    """Create a new bsfs storage structure."""
    parser = argparse.ArgumentParser(description=main.__doc__, prog='init')
    # global arguments
    parser.add_argument('--user', type=str, default='http://example.com/me',
        help='Default user.')
    parser.add_argument('--output', type=str, default=None,
        help='Write the config to a file instead of standard output.')
    #parser.add_argument('--schema', type=str, default=None,
    #    help='Initial schema.')
    # storage selection
    parser.add_argument('store', choices=('sparql', ),
        help='Which storage to initialize.')
    # storage args
    # parse args
    args = parser.parse_args(argv)

    # initialize selected storage
    if args.store == 'sparql':
        config = init_sparql_store(args.user)
    else:
        raise errors.UnreachableError()

    # print config
    if args.output is not None:
        with open(args.output, mode='wt', encoding='UTF-8') as ofile:
            json.dump(config, ofile, indent=4)
    else:
        json.dump(config, sys.stdout, indent=4)
        print('')


## main ##

if __name__ == '__main__':
    main(sys.argv[1:])

## EOF ##
