
# imports
import typing

# bsfs imports
from bsfs.graph import Graph

# inner-module imports
from . import builder

# exports
__all__: typing.Sequence[str] = (
    'Open',
    )


## code ##

# NOTE: Capitalized to mark entry point and to separate from builtin open.
def Open(cfg: typing.Any) -> Graph: # pylint: disable=invalid-name
    """Open a BSFS storage and return a `bsfs.graph.Graph` instance."""
    return builder.build_graph(cfg)

## EOF ##
