
# imports
import typing

# bsfs imports
from bsfs import schema
from bsfs.namespace import ns
from bsfs.query import ast
from bsfs.utils import URI

# inner-module imports
from . import base

# exports
__all__: typing.Sequence[str] = (
    'NullAC',
    )


## code ##

class NullAC(base.AccessControlBase):
    """The NULL access control implements a dummy policy that allows any action to any user."""

    def is_protected_predicate(self, pred: schema.Predicate) -> bool:
        """Return True if a predicate cannot be modified manually."""
        return pred.uri == ns.bsn.t_created

    def create(self, node_type: schema.Node, guids: typing.Iterable[URI]):
        """Perform post-creation operations on nodes, e.g. ownership information."""

    def link_from_node(self, node_type: schema.Node, guids: typing.Iterable[URI]) -> typing.Iterable[URI]:
        """Return nodes for which outbound links can be written."""
        return guids

    def link_to_node(self, node_type: schema.Node, guids: typing.Iterable[URI]) -> typing.Iterable[URI]:
        """Return nodes for which inbound links can be written."""
        return guids

    def write_literal(self, node_type: schema.Node, guids: typing.Iterable[URI]) -> typing.Iterable[URI]:
        """Return nodes to which literals can be attached."""
        return guids

    def createable(self, node_type: schema.Node, guids: typing.Iterable[URI]) -> typing.Iterable[URI]:
        """Return nodes that are allowed to be created."""
        return guids

    def filter_read(
            self,
            node_type: schema.Node,
            query: typing.Optional[ast.filter.FilterExpression]
            ) -> typing.Optional[ast.filter.FilterExpression]:
        """Re-write a filter *query* to get (i.e., read) *node_type* nodes."""
        return query

    def fetch_read(self, node_type: schema.Node, query: ast.fetch.FetchExpression) -> ast.fetch.FetchExpression:
        """Re-write a fetch *query* to get (i.e, read) values for *node_type* nodes."""
        return query

## EOF ##
