
# imports
import typing

# bsfs imports
from bsfs.utils import URI

# exports
__all__: typing.Sequence[str] = (
    'Namespace',
    'FinalNamespace',
    )


## code ##


class Namespace(URI):
    """The Namespace allows you to incrementally append path segments to an URI.

    Segments are separated by `Namespace.sep` ('/').
    The `__call__` method signals that the URI is complete until the query part.

    """

    # path separator
    sep: str = '/'

    def __getattr__(self, query: str) -> 'Namespace':
        """Append the *query* to the current value and return as Namespace."""
        return Namespace(self + self.sep + query)

    def __call__(self, sep: str = '#') -> 'FinalNamespace':
        """Finalize the namespace."""
        return FinalNamespace(self, sep)


# FIXME: Integrate FinalNamespace into Namespace? Do we need to have both?
class FinalNamespace(URI):
    """The FinalNamespace allows you to append a fragment to an URI."""

    # fragment separator
    sep: str

    def __new__(cls, value: str, sep: str = '#'):
        inst = URI.__new__(cls, value)
        inst.sep = sep
        return inst

    def __getattr__(self, fragment: str) -> URI:
        """Append the *fragment* to the current value and return as URI."""
        return URI(self + self.sep + fragment)

## EOF ##
