
# imports
import typing

# inner-module imports
from .namespace import Namespace, FinalNamespace

# essential bsfs namespaces
bsfs = Namespace('https://schema.bsfs.io/core')
# additional bsfs namespaces
bsd = bsfs.distance()
bsl = bsfs.Literal
bsn = bsfs.Node()

# generic namespaces
rdf = FinalNamespace('http://www.w3.org/1999/02/22-rdf-syntax-ns')
rdfs = FinalNamespace('http://www.w3.org/2000/01/rdf-schema')
xsd = FinalNamespace('http://www.w3.org/2001/XMLSchema')
schema = FinalNamespace('http://schema.org', sep='/')

# exports
__all__: typing.Sequence[str] = (
    'bsd',
    'bsfs',
    'bsl',
    'bsn',
    'rdf',
    'rdfs',
    'schema',
    'xsd',
    )

## EOF ##
