"""Query AST components.

The query AST consists of a Filter and a Fetch syntax trees.

Classes beginning with an underscore (_) represent internal type hierarchies
and should not be used for parsing. Note that the AST structures do not
(and cannot) check semantic validity or consistency with a given schema.

"""
# imports
import typing

# inner-module imports
from . import fetch
from . import filter_ as filter # pylint: disable=redefined-builtin

# exports
__all__: typing.Sequence[str] = (
    'fetch',
    'filter',
    )

## EOF ##
