
# imports
import typing

# exports
__all__: typing.Sequence[str] = (
    )


## code ##

class _BSFSError(Exception):
    """Generic bsfs error."""

class SchemaError(_BSFSError):
    """Generic schema errios."""

class ConsistencyError(SchemaError):
    """A requested operation is inconsistent with the schema."""

class InstanceError(SchemaError):
    """An instance affected by some operation is inconsistent with the schema."""

class PermissionDeniedError(_BSFSError):
    """An operation was aborted due to access control restrictions."""

class ProgrammingError(_BSFSError):
    """An assertion-like error that indicates a code-base issue."""

class UnreachableError(ProgrammingError):
    """Bravo, you've reached a point in code that should logically not be reachable."""

class ConfigError(_BSFSError):
    """User config issue."""

class BackendError(_BSFSError):
    """Could not parse an AST structure."""

class UnsupportedError(_BSFSError):
    """Some requested functionality is not supported by an implementation."""

## EOF ##
