
from setuptools import setup, find_packages
import os

setup(
    # package metadata
    name='bsfs',
    version='0.23.03',
    author='Matthias Baumgartner',
    author_email='dev@bsfs.io',
    description='A content-aware graph file system.',
    long_description=open(os.path.join(os.path.dirname(__file__), 'README.md')).read(),
    license='BSD',
    license_files=('LICENSE', ),
    url='https://www.bsfs.io/bsfs/',
    download_url='https://pip.bsfs.io',

    # packages
    packages=find_packages(include=['bsfs']),
    package_dir={'bsfs': 'bsfs'},
    # data files are included if mentioned in MANIFEST.in
    include_package_data=True,

    # entrypoints
    entry_points={
        'console_scripts': [
            'bsfs = bsfs.apps:main',
            ],
        },

    # dependencies
    python_requires=">=3.7",
    install_requires=(
        'rdflib', # schema and sparql storage
        'hopcroftkarp', # ast matching
        'numpy', # distance functions for sparql store
        ),
    extras_require={
        'dev': ['coverage', 'mypy', 'pylint'],
        'doc': ['sphinx', 'furo', 'sphinx-copybutton'],
        'test': [],
        'build': ['build'],
        },
)
