#!/usr/bin/env python3
"""BSIE tools.
"""
# standard imports
import argparse
import typing

# bsie imports
import bsie

# inner-module imports
from .index import main as index
from .info import main as info

# exports
__all__: typing.Sequence[str] = (
    'index',
    'info',
    'main',
    )

# config
apps = {
    'index'     : index,
    'info'      : info,
    }


## code ##

def main(argv=None):
    """Black Star File System maintenance tools."""
    parser = argparse.ArgumentParser(description=main.__doc__, prog='bsie')
    # version
    parser.add_argument('--version', action='version',
        version='%(prog)s version {}.{}.{}'.format(*bsie.version_info)) # pylint: disable=C0209
    # application selection
    parser.add_argument('app', choices=apps.keys(),
        help='Select the application to run.')
    # dangling args
    parser.add_argument('rest', nargs=argparse.REMAINDER)
    # parse
    args = parser.parse_args(argv)
    # run application
    apps[args.app](args.rest)


## main ##

if __name__ == '__main__':
    import sys
    main(sys.argv[1:])

## EOF ##
