
# standard imports
import argparse
import os
import sys
import typing

# bsie imports
from bsie.utils import bsfs, errors

# inner-module imports
from . import _loader

# exports
__all__: typing.Sequence[str] = (
    'main',
    )


## code ##

def main(argv):
    """Show information from BSIE."""
    parser = argparse.ArgumentParser(description=main.__doc__, prog='info')
    parser.add_argument('--config', type=str,
        default=os.path.join(os.path.dirname(__file__), _loader.DEFAULT_CONFIG_FILE),
        help='Path to the config file.')
    parser.add_argument('what', choices=('predicates', 'schema'),
        help='Select what information to show.')
    args = parser.parse_args(argv)

    # build pipeline
    pipeline = _loader.load_pipeline(args.config)

    # show info
    if args.what == 'predicates':
        # show predicates
        for pred in pipeline.schema.predicates():
            print(pred.uri)
    elif args.what == 'schema':
        # show schema
        print(bsfs.schema.to_string(pipeline.schema))
    else:
        # args.what is already checked by argparse
        raise errors.UnreachableError()


## main ##

if __name__ == '__main__':
    main(sys.argv[1:])

## EOF ##
