"""The Constant extractor produces pre-specified triples.
"""
# standard imports
import typing

# bsie imports
from bsie.utils import bsfs, node

# inner-module imports
from .. import base

# exports
__all__: typing.Sequence[str] = (
    'Constant',
    )


## code ##

class Constant(base.Extractor):
    """Extract information from file's path."""

    CONTENT_READER = None

    # predicate/value pairs to be produced.
    _tuples: typing.Tuple[typing.Tuple[bsfs.schema.Predicate, typing.Any], ...]

    def __init__(
            self,
            schema: str,
            tuples: typing.Iterable[typing.Tuple[bsfs.URI, typing.Any]],
            ):
        super().__init__(bsfs.schema.from_string(base.SCHEMA_PREAMBLE + schema))
        # NOTE: Raises a KeyError if the predicate is not part of the schema
        self._tuples = tuple((self.schema.predicate(p_uri), value) for p_uri, value in tuples)
        # TODO: use schema instance for value checking

    def __eq__(self, other: typing.Any) -> bool:
        return super().__eq__(other) \
           and self._tuples == other._tuples

    def __hash__(self) -> int:
        return hash((super().__hash__(), self._tuples))

    def extract(
            self,
            subject: node.Node,
            content: None,
            principals: typing.Iterable[bsfs.schema.Predicate],
            ) -> typing.Iterator[typing.Tuple[node.Node, bsfs.schema.Predicate, typing.Any]]:
        for pred, value in self._tuples:
            if pred in principals:
                yield subject, pred, value

## EOF ##
