"""The Reader classes return high-level content structures from files.

The Reader fulfills two purposes:
First, it brokers between multiple libraries and file formats.
Second, it separates multiple aspects of a file into distinct content types.

Often, different libraries focus on reading different types of content from a
file. E.g. one would use different modules to read file system infos than to
read exif or pixel data of an image. Hence, this module is organized by content
type. Each distinct type can be implemented in a file or submodule that
provides a Reader implementation. Through utilization of submodules, different
file formats can be supported.

"""
# standard imports
import typing

# inner-module imports
from .base import Reader
from .builder import ReaderBuilder

# exports
__all__: typing.Sequence[str] = (
    'Reader',
    'ReaderBuilder',
    )

## EOF ##
