
# standard imports
import abc
import typing

# bsie imports
from bsie.utils import bsfs

# exports
__all__: typing.Sequence[str] = (
    'Reader',
    )


## code ##

class Reader(abc.ABC):
    """Read and return some content from a file."""

    def __str__(self) -> str:
        return bsfs.typename(self)

    def __repr__(self) -> str:
        return f'{bsfs.typename(self)}()'

    def __eq__(self, other: typing.Any) -> bool:
        return isinstance(other, type(self))

    def __hash__(self) -> int:
        return hash(type(self))

    @abc.abstractmethod
    def __call__(self, path: str) -> typing.Any:
        """Return some content of the file at *path*.
        Raises a `ReaderError` if the reader cannot make sense of the file format.
        """

## EOF ##
