
# standard imports
import typing

# external imports
import pyexiv2

# bsie imports
from bsie.utils import errors, filematcher

# inner-module imports
from . import base

# constants
MATCH_RULE = 'mime=image/jpeg'

# exports
__all__: typing.Sequence[str] = (
    'Exif',
    )


## code ##

class Exif(base.Reader):
    """Use pyexiv2 to read exif metadata from image files."""

    def __init__(self):
        self._match = filematcher.parse(MATCH_RULE)

    def __call__(self, path: str) -> dict:
        # perform quick checks first
        if not self._match(path):
            raise errors.UnsupportedFileFormatError(path)

        try:
            # open the file
            img = pyexiv2.Image(path)
            # read metadata
            return img.read_exif()
        except (TypeError, OSError, RuntimeError) as err:
            raise errors.ReaderError(path) from err

## EOF ##
