
# standard imports
import typing

# external imports
import PIL.Image

# inner-module imports
from .. import chain

# constants
_FILE_FORMAT_READERS: typing.Sequence[str] = (
    __package__ + '._raw.RawImage',
    __package__ + '._pillow.PillowImage',
    )

# exports
__all__: typing.Sequence[str] = (
    'Image',
    )


## code ##

class Image(chain.ReaderChain[PIL.Image.Image]): # pylint: disable=too-few-public-methods
    """Read an image file."""

    def __init__(self, cfg: typing.Optional[typing.Any] = None):
        super().__init__(_FILE_FORMAT_READERS, cfg)

## EOF ##
