
# standard imports
import typing

# external imports
import PIL.Image

# bsie imports
from bsie.utils import errors

# inner-module imports
from .. import base

# exports
__all__: typing.Sequence[str] = (
    'PillowImage',
    )


## code ##

class PillowImage(base.Reader):
    """Use PIL to read content of a variety of image file types."""

    def __call__(self, path: str) -> PIL.Image.Image:
        try:
            # open file with PIL
            return PIL.Image.open(path)
        except PIL.UnidentifiedImageError as err:
            raise errors.UnsupportedFileFormatError(path) from err
        except IOError as err:
            raise errors.ReaderError(path) from err

# EOF ##
