
# imports
import typing

# external imports
import PIL.Image

# inner-module imports
from .. import chain

# constants
_FILE_FORMAT_READERS: typing.Sequence[str] = (
    # native image formats
    __package__ + '._pillow.PillowPreviewReader',
    __package__ + '._rawpy.RawpyPreviewReader',
    # multiformat readers
    __package__ + '._pg.PreviewGeneratorReader',
    )

# exports
__all__: typing.Sequence[str] = (
    'Preview',
    )


## code ##

class Preview(chain.ReaderChain[typing.Callable[[int], PIL.Image.Image]]): # pylint: disable=too-few-public-methods
    """Create a preview from a file."""

    def __init__(self, cfg: typing.Optional[typing.Any] = None):
        super().__init__(_FILE_FORMAT_READERS, cfg)

## EOF ##
