
# standard imports
from functools import partial
import typing

# external imports
import PIL.Image

# bsie imports
from bsie.utils import errors

# inner-module imports
from . import utils
from .. import base

# exports
__all__: typing.Sequence[str] = (
    'PillowPreviewReader',
    )


## code ##

class PillowPreviewReader(base.Reader):
    """Produce previews for image files using the Pillow library."""

    def __call__(self, path: str) -> typing.Callable[[int], PIL.Image.Image]:
        try:
            # open file with PIL
            img = PIL.Image.open(path)
            # return callback
            return partial(utils.resize, img)
        except PIL.UnidentifiedImageError as err:
            # failed to open, skip file
            raise errors.UnsupportedFileFormatError(path) from err
        except OSError as err:
            raise errors.ReaderError(path) from err

# EOF ##
