
# standard imports
import typing

# external imports
import PIL.Image

# exports
__all__: typing.Sequence[str] = (
    'resize',
    )


## code ##

def resize(
        img: PIL.Image.Image,
        max_size: int,
        ) -> PIL.Image.Image:
    """Resize an image to a given maximum side length."""
    # determine target dimensions
    ratio = img.width / img.height
    if img.width > img.height:
        width, height = max_size, round(max_size / ratio)
    else:
        width, height = round(ratio * max_size), max_size
    # rescale and return
    return img.resize(
        (width, height),
        resample=PIL.Image.Resampling.LANCZOS, # create high-quality image
        reducing_gap=3.0, # optimize computation via fast size reduction
        )

## EOF ##
