"""The Stat reader produces filesystem stat information.
"""
# standard imports
import os
import typing

# bsie imports
from bsie.utils import errors

# inner-module imports
from . import base

# exports
__all__: typing.Sequence[str] = (
    'Stat',
    )


## code ##

class Stat(base.Reader):
    """Read and return the filesystem's stat infos."""

    def __call__(self, path: str) -> os.stat_result:
        try:
            return os.stat(path)
        except Exception as err:
            raise errors.ReaderError(path) from err


## EOF ##
