"""Common BSIE exceptions.
"""
# standard imports
import typing

# exports
__all__: typing.Sequence[str] = (
    'BuilderError',
    'ExtractorError',
    'LoaderError',
    'ReaderError',
    )


## code ##

class _BSIEError(Exception):
    """Generic BSIE error."""

class BuilderError(_BSIEError):
    """The Builder failed to create an instance."""

class LoaderError(BuilderError):
    """Failed to load a module or class."""

class ExtractorError(_BSIEError):
    """The Extractor failed to process the given content."""

class ReaderError(_BSIEError):
    """The Reader failed to read the given file."""

class ProgrammingError(_BSIEError):
    """An assertion-like error that indicates a code-base issue."""

class UnreachableError(ProgrammingError):
    """Bravo, you've reached a point in code that should logically not be reachable."""

class ParserError(_BSIEError):
    """Failed to parse due to invalid syntax or structures."""

class UnsupportedFileFormatError(_BSIEError):
    """Failed to read a file format."""

## EOF ##
