"""Default namespaces used throughout BSIE.
"""
# standard imports
import typing

# inner-module imports
from . import bsfs as _bsfs

# generic namespaces
xsd = _bsfs.Namespace('http://www.w3.org/2001/XMLSchema')()

# core bsfs/bsie namespaces
bsfs = _bsfs.Namespace('https://schema.bsfs.io/core')
bsie = _bsfs.Namespace('https://schema.bsfs.io/ie')

# auxiliary namespaces
bsd = bsie.distance()
bse = bsie.Node.Entity()
bsf = bsie.Literal.Array.Feature
bsl = bsfs.Literal
bsn = bsie.Node
bsp = bsie.Node.Preview()

# export
__all__: typing.Sequence[str] = (
    'bsd',
    'bse',
    'bsf',
    'bsfs',
    'bsie',
    'bsl',
    'bsl',
    'bsn',
    'bsp',
    'xsd',
    )

## EOF ##
