
from setuptools import setup, find_packages
import os

extras = {
    # NOTE: an 'all' extra is added automatically
    'features': [
        # image feature extractors
        'numpy',
        ],
    'preview': [
        # preview readers
        'preview_generator', # also depends on some system packages
        'pillow',
        'rawpy',
        ],
    'image': [
        # image readers
        'pillow',
        'rawpy',
        # exif reader
        'pyexiv2',
        ],
    }


setup(
    # package metadata
    name='bsie',
    version='0.23.03',
    author='Matthias Baumgartner',
    author_email='dev@bsfs.io',
    description='Extract information from files and store them in a BSFS.',
    long_description=open(os.path.join(os.path.dirname(__file__), 'README.md')).read(),
    license='BSD',
    license_files=('LICENSE', ),
    url='https://www.bsfs.io/bsie/',
    download_url='https://pip.bsfs.io',

    # packages
    packages=find_packages(include=['bsie']),
    package_dir={'bsie': 'bsie'},
    # data files are included if mentioned in MANIFEST.in
    include_package_data=True,

    # entrypoints
    entry_points={
        'console_scripts': [
            'bsie = bsie.apps:main',
            ],
        },

    # dependencies
    python_requires=">=3.7",
    install_requires=(
        'bsfs',
        'pyparsing',
        'python-magic',
        'pyyaml',
        ),
    extras_require=dict(
        # development targets
        build=['build'],
        dev=['coverage', 'mypy', 'pylint'],
        doc=['sphinx', 'sphinx-copybutton', 'furo'],
        test=['rdflib', 'requests', 'types-PyYAML'],
        # add 'all'
        all=list({pkg for ext in extras.values() for pkg in ext}),
        # add extras
        **extras
        ),
    )

