
tagit - the BSFS browser
========================

tagit is a graphical interface to browse through a BSFS storage. It is designed
with image collections in mind, therefore provides a means to quickly navigate a
collection by user-assigned tags, and to easily edit images' tags.


## Installation

You can install tagit via pip:

    $ pip install --extra-index-url https://pip.bsfs.io tagit


## Development

Set up a virtual environment:

    $ virtualenv env
    $ source env/bin/activate

Install tagit as editable from the git repository:

    $ git clone https://git.bsfs.io/tagit.git
    $ cd tagit
    $ pip install -e .

If you want to develop (*dev*), run the tests (*test*), edit the
documentation (*doc*), or build a distributable (*build*),
install bsfs with the respective extras (in addition to file format extras):

    $ pip install -e .[dev,doc,build,test]

Or, you can manually install the following packages besides tagit:

    $ pip install coverage mypy pylint
    $ pip install sphinx sphinx-copybutton sphinxcontrib-video furo
    $ pip install build
    $ pip install pyexiv2

To ensure code style discipline, run the following commands:

    $ coverage run ; coverage html ; xdg-open .htmlcov/index.html
    $ pylint tagit
    $ mypy

To build the package, do:

    $ python -m build

To run only the tests (without coverage), run the following command from the **test folder**:

    $ python -m unittest

To build the documentation, run the following commands from the **doc folder**:

    $ make html
    $ xdg-open build/html/index.html


