
from setuptools import setup, find_packages, Extension
import os

setup(
    # package metadata
    name='tagit',
    version='0.23.03',
    author='Matthias Baumgartner',
    author_email='dev@bsfs.io',
    description='The Black Star File System (BSFS) browser and tagger.',
    long_description=open(os.path.join(os.path.dirname(__file__), 'README.md')).read(),
    license='BSD',
    license_files=('LICENSE', ),
    url='https://www.bsfs.io/tagit/',
    download_url='https://pip.igsor.net',

    # packages
    packages=find_packages(include=['tagit']),
    package_dir={'tagit': 'tagit'},
    # data files are included if mentioned in MANIFEST.in
    include_package_data=True,
    # setproperty needs to be compiled
    # NOTE: Assumes that setproperty has already been cythonized!
    ext_modules=[
        Extension(
            name='tagit.external.setproperty.setproperty',
            sources=['tagit/external/setproperty/setproperty.c'],
            ),
        ],

    # entrypoints
    entry_points={
        'console_scripts': [
            'tagit = tagit.apps:main',
            ],
        },

    # dependencies
    python_requires=">=3.7",
    install_requires=(
        'bsfs',
        'pillow',
        'kivy',
        'pyparsing',
        'python-dateutil',
        'pyyaml',
        'requests',
        ),

    extras_require={
        'dev': ['coverage', 'mypy', 'pylint'],
        'doc': ['sphinx', 'sphinx-copybutton', 'sphinxcontrib-video', 'furo'],
        'test': ['pyexiv2'],
        'build': ['build'],
        },
)

