"""

Part of the tagit module.
A copy of the license is provided with the project.
Author: Matthias Baumgartner, 2022
"""
# standard imports
import typing

# tagit imports
from tagit.utils.builder import BuilderBase

# inner-module imports
from . import browser
from . import filter
from . import grouping
from . import misc
#from . import objects
from . import search
from . import session
from . import tagging

# exports
__all__: typing.Sequence[str] = (
    'ActionBuilder',
    )


## code ##

class ActionBuilder(BuilderBase):
    _factories = {
        ## browser
        'NextPage': browser.NextPage,
        'PreviousPage': browser.PreviousPage,
        'ScrollDown': browser.ScrollDown,
        'ScrollUp': browser.ScrollUp,
        'JumpToPage': browser.JumpToPage,
        'SetCursor': browser.SetCursor,
        'ZoomIn': browser.ZoomIn,
        'ZoomOut': browser.ZoomOut,
        'JumpToCursor': browser.JumpToCursor,
        'MoveCursorFirst': browser.MoveCursorFirst,
        'MoveCursorLast': browser.MoveCursorLast,
        'MoveCursorUp': browser.MoveCursorUp,
        'MoveCursorDown': browser.MoveCursorDown,
        'MoveCursorLeft': browser.MoveCursorLeft,
        'MoveCursorRight': browser.MoveCursorRight,
        'SelectRange': browser.SelectRange,
        'SelectAdditive': browser.SelectAdditive,
        'SelectSubtractive': browser.SelectSubtractive,
        'SelectMulti': browser.SelectMulti,
        'SelectSingle': browser.SelectSingle,
        'SelectAll': browser.SelectAll,
        'SelectNone': browser.SelectNone,
        'SelectInvert': browser.SelectInvert,
        'Select': browser.Select,
        ## filter
        'AddToken': filter.AddToken,
        'RemoveToken': filter.RemoveToken,
        'SetToken': filter.SetToken,
        'EditToken': filter.EditToken,
        'GoBack': filter.GoBack,
        'GoForth': filter.GoForth,
        'JumpToToken': filter.JumpToToken,
        'SearchByAddressOnce': filter.SearchByAddressOnce,
        'SearchmodeSwitch': filter.SearchmodeSwitch,
        ## grouping
        'CreateGroup': grouping.CreateGroup,
        'DissolveGroup': grouping.DissolveGroup,
        'AddToGroup': grouping.AddToGroup,
        'OpenGroup': grouping.OpenGroup,
        #'RepresentGroup': grouping.RepresentGroup,
        #'RemoveFromGroup': grouping.RemoveFromGroup,
        ## misc
        'ShellDrop': misc.ShellDrop,
        'OpenExternal': misc.OpenExternal,
        'Menu': misc.Menu,
        'ShowConsole': misc.ShowConsole,
        'ShowHelp': misc.ShowHelp,
        'ShowSettings': misc.ShowSettings,
        #'ClipboardCopy': misc.ClipboardCopy,
        #'ClipboardPaste': misc.ClipboardPaste,
        ## objects
        #'RotateLeft': objects.RotateLeft,
        #'RotateRight': objects.RotateRight,
        #'DeleteObject': objects.DeleteObject,
        'AddTag': tagging.AddTag,
        'EditTag': tagging.EditTag,
        #'SetRank1': objects.SetRank1,
        #'SetRank2': objects.SetRank2,
        #'SetRank3': objects.SetRank3,
        #'SetRank4': objects.SetRank4,
        #'SetRank5': objects.SetRank5,
        ## search
        'Search': search.Search,
        'ShowSelected': search.ShowSelected,
        'RemoveSelected': search.RemoveSelected,
        #'SortKey': search.SortKey,
        'SortOrder': search.SortOrder,
        ## session
        'LoadSession': session.LoadSession,
    }

## EOF ##
