"""

Part of the tagit module.
A copy of the license is provided with the project.
Author: Matthias Baumgartner, 2022
"""
# standard imports
import os

# kivy imports
from kivy.lang import Builder
import kivy.properties as kp

# tagit imports
from tagit import config, dialogues
from tagit.config.loader import load_settings

# inner-module imports
from .action import Action

# exports
__all__ = []


## code ##

# load kv
Builder.load_file(os.path.join(os.path.dirname(__file__), 'session.kv'))

# classes
class LoadSession(Action):
    """Load a session from a project file."""
    text = kp.StringProperty('Load')

    def apply(self):
        """Open a file load dialogue to select a session file."""
        dlg = dialogues.FilePicker(title='Select a session file to load')
        dlg.bind(on_ok=self.load_from_path)
        dlg.open()

    def load_from_path(self, wx):
        """Load a session from *path*."""
        with self.root.session as session:
            try:
                if not os.path.exists(wx.path) or not os.path.isfile(wx.path):
                    raise FileNotFoundError(wx.path)

                # load config from path
                cfg = load_settings(wx.path, verbose=self.cfg('session', 'verbose'))
                session.load(cfg)

            except Exception as e:
                dialogues.Error(text=f'The file cannot be loaded ({e})').open()


## EOF ##
