#!/usr/bin/env python3
"""The tagit applications.

Part of the tagit module.
A copy of the license is provided with the project.
Author: Matthias Baumgartner, 2022
"""
# standard imports
import argparse
import typing

# tagit imports
import tagit

# inner-module imports
from .desktop import main as desktop

# exports
__all__: typing.Sequence[str] = (
    'desktop',
    'main',
    )

# config
apps = {
    'desktop'       : desktop,
    }


## code ##

def main(argv=None):
    """The BSFS browser, focused on image tagging."""
    parser = argparse.ArgumentParser(description=main.__doc__, prog='tagit')
    # version
    parser.add_argument('--version', action='version',
        version='%(prog)s {}.{}.{}'.format(*tuple(tagit.version_info))) # pylint: disable=C0209
    # application selection
    parser.add_argument('app', choices=apps.keys(), nargs='?', default='desktop',
        help='Select the application to run.')
    # dangling args
    parser.add_argument('rest', nargs=argparse.REMAINDER)
    # parse
    args = parser.parse_args()
    # run application
    apps[args.app](args.rest)

if __name__ == '__main__':
    import sys
    main(sys.argv[1:])

## EOF ##
