"""Configuration system.

Part of the tagit module.
A copy of the license is provided with the project.
Author: Matthias Baumgartner, 2022
"""
# standard imports
import typing

# inner-module imports
from . import loader
from . import utils
from .loader import TAGITRC, DEFAULT_USER_CONFIG
from .schema import schema, declare, declare_title
from .settings import Settings, ConfigError
from .types import *

# exports
__all__: typing.Sequence[str] = (
    'Settings',
    'TAGITRC',
    'schema',
    )

## EOF ##
