"""Popup dialogues.

A dialogue can be opened from the main application.
It appears on top of the application and prevent its use until the dialogue
is closed. A dialogue contains buttons whose presses can be captured.

>>> dlg = LabelDialogue(text='Hello world')
>>> dlg.bind(on_ok=...)
>>> dlg.bind(on_cancel=...)
>>> dlg.open()

Part of the tagit module.
A copy of the license is provided with the project.
Author: Matthias Baumgartner, 2022
"""
# standard imports
import typing

# inner-module imports
from .autoinput import AutoTextInput
from .console import Console
from .error import Error
from .file_picker import FilePicker
from .message import Message
from .numeric_input import NumericInput
from .path_picker import PathPicker
from .simple_input import SimpleInput
from .stoken import TokenEdit

# exports
__all__: typing.Sequence[str] = (
    'Console',
    'Error',
    'FilePicker',
    'Message',
    'NumericInput',
    'PathPicker',
    'SimpleInput',
    'TokenEdit',
    )

## EOF ##
