"""

Part of the tagit module.
A copy of the license is provided with the project.
Author: Matthias Baumgartner, 2022
"""
# standard imports
import os

# kivy imports
from kivy.clock import mainthread
from kivy.lang import Builder
import kivy.properties as kp

# inner-module imports
from .dialogue import Dialogue

# exports
__all__ = ('Console', )


## code ##

# load kv
Builder.load_file(os.path.join(os.path.dirname(__file__), 'console.kv'))

# classes
class Console(Dialogue):
    """Dialogue with console output."""

    text = kp.StringProperty('')

    @mainthread
    def update(self, sender, text):
        self.text = '\n'.join(text)

## EOF ##
