"""Dialogue to show an error message.

Part of the tagit module.
A copy of the license is provided with the project.
Author: Matthias Baumgartner, 2022
"""
# kivy imports
from kivy.lang import Builder
import kivy.properties as kp

# inner-module imports
from .dialogue import Dialogue

# exports
__all__ = ('Error', )


## code ##

# load kv
Builder.load_string('''
<Error>:
    text: ''
    ok_on_enter: False

    DialogueContentNoTitle:

        Label:
            markup: True
            text: root.text
            size_hint_y: None
            color: 1, 0, 0, 1
            height: self.texture_size[1] + dp(16)
            text_size: self.width - dp(16), None
            halign: 'center'

        DialogueButtons_One:
''')

# classes
class Error(Dialogue):
    """Error message."""
    text = kp.StringProperty('')

## EOF ##
