"""Dialogue to pick a file.

Part of the tagit module.
A copy of the license is provided with the project.
Author: Matthias Baumgartner, 2022
"""
# standard imports
import os

# kivy imports
from kivy.lang import Builder

# inner-module imports
from .path_picker import PathPicker
from .error import Error

# exports
__all__ = ('FilePicker', )


## code ##

# load kv
Builder.load_string('''
<FilePicker>:
    dirselect: False
    title: 'Please select a file'
''')

# classes
class FilePicker(PathPicker):
    """Dialogue with a file browser to select a file."""
    def ok(self):
        if not os.path.exists(self.path) or not os.path.isfile(self.path):
            Error(text='Please select a file').open()
        else:
            super(FilePicker, self).ok()

## EOF ##
