"""Dialogue to show some message.

Part of the tagit module.
A copy of the license is provided with the project.
Author: Matthias Baumgartner, 2022
"""
# kivy imports
from kivy.lang import Builder
import kivy.properties as kp

# inner-module imports
from .dialogue import Dialogue

# exports
__all__ = ('Message', )


## code ##

# load kv
Builder.load_string('''
<Message>:
    text: ''
    align: 'center'
    textcolor: 1,1,1,1

    DialogueContentNoTitle:
        Label:
            text: root.text
            size_hint_y: None
            color: root.textcolor
            height: self.texture_size[1] + dp(16)
            text_size: self.width - dp(16), None
            halign: root.align
            markup: True

        DialogueButtons_One:
''')

# classes
class Message(Dialogue):
    """Dialogue to show a text message."""
    text = kp.StringProperty()
    align = kp.StringProperty()
    textcolor: kp.ListProperty()

## EOF ##
