"""Dialogue with a slider.

Part of the tagit module.
A copy of the license is provided with the project.
Author: Matthias Baumgartner, 2022
"""
# kivy imports
from kivy.lang import Builder
import kivy.properties as kp

# inner-module imports
from .dialogue import Dialogue

# exports
__all__ = ('NumericInput', )


## code ##

# load kv
Builder.load_string('''

<NumericInput>:
    value: int(slider.value)
    init_value: 0

    DialogueContentNoTitle:

        BoxLayout:
            orientation: 'horizontal'
            size_hint_y: None
            height: 50

            Label:
                text: str(root.lo)
                size_hint_x: None
                width: self.texture_size[0]

            Slider:
                id: slider
                orientation: 'horizontal'
                min: root.lo
                max: root.hi
                step: 1
                value: root.init_value

            Label:
                text: str(root.hi)
                size_hint_x: None
                width: self.texture_size[0]

        Label:
            text: str(root.value)
            size_hint: 1, None
            height: self.texture_size[1]
            halign: 'center'

        DialogueButtons_Two:

''')

# classes
class NumericInput(Dialogue):
    """Dialogue with a slider."""

    lo = kp.NumericProperty(0)
    hi = kp.NumericProperty(100)
    value = kp.NumericProperty(0)
    init_value = kp.NumericProperty(0)


## EOF ##
