"""Dialogue to pick a file or directory.

Part of the tagit module.
A copy of the license is provided with the project.
Author: Matthias Baumgartner, 2022
"""
# standard imports
import os

# kivy imports
from kivy.lang import Builder
import kivy.properties as kp

# inner-module imports
from .dialogue import Dialogue
from .error import Error

# exports
__all__ = ('PathPicker', )


## code ##

# load kv
Builder.load_file(os.path.join(os.path.dirname(__file__), 'path_picker.kv'))

# classes
class PathPicker(Dialogue):
    """Dialogue with a file browser to select a file or directory."""

    title = kp.StringProperty('')
    path = kp.StringProperty('')
    filters = kp.ListProperty()

    def ok(self):
        if not os.path.exists(self.path):
            Error(text='Please select a file or directory').open()
        else:
            super(PathPicker, self).ok()

## EOF ##
