"""Dialogue with a single-line text input field.

Part of the tagit module.
A copy of the license is provided with the project.
Author: Matthias Baumgartner, 2022
"""
# standard imports
import os

# kivy imports
from kivy.lang import Builder
import kivy.properties as kp

# inner-module imports
from .dialogue import Dialogue

# exports
__all__ = ('SimpleInput', )


## code ##

# load kv
Builder.load_file(os.path.join(os.path.dirname(__file__), 'simple_input.kv'))

# classes
class SimpleInput(Dialogue):
    """Dialogue with a single-line text input field.

    Pass the default text as **text**.

    >>> SimpleInput(text='Hello world').open()

    In case of touch events, they need to be inhibited to change the focus.

    >>> FocusBehavior.ignored_touch.append(touch)

    """

    # Defocus problem:
    # Buttons defocus when on_press, but on_release is ok.
    # Touch events must be blocked via FocusBehavior

    text = kp.StringProperty('')
    cancel_on_defocus = kp.BooleanProperty(True)
    suggestions = kp.ListProperty()
    suggestion_sep = kp.StringProperty(',')
    suggestion_suffix = kp.StringProperty(' ')


    def on_text_focus(self, instance, focus):
        if not focus and self.cancel_on_defocus:
            self.dismiss()

## EOF ##
