"""Tooltips.

From:
    http://stackoverflow.com/questions/34468909/how-to-make-tooltip-using-kivy

Part of the tagit module.
A copy of the license is provided with the project.
Author: Matthias Baumgartner, 2022

"""
# standard imports
import os

# kivy imports
from kivy.lang import Builder
from kivy.uix.label import Label
from kivy.clock import Clock
# Cannot import kivy.core.window.Window here; Leads to a segfault.
# Doing it within the *Tooltip* class works just fine, though.

# exports
__all__ = ('Tooltip', )


## CODE ##

Builder.load_file(os.path.join(os.path.dirname(__file__), 'tooltip.kv'))

class Tooltip_Label(Label):
    pass

# FIXME: Tooltip makes the whole UI *way* too slow, hence it's body is disabled
class Tooltip(object):
    def set_tooltip(self, text):
        pass

#        if hasattr(self, '_tooltip_wx') and self._tooltip_wx is not None:
#            self._tooltip_wx.text = text
#        else:
#            self._tooltip_wx = Tooltip_Label(text=text)
#            from kivy.core.window import Window
#            Window.bind(mouse_pos=self.on_mouse_pos)
#
#    def on_mouse_pos(self, *args):
#        if not self.get_root_window():
#            return
#
#        pos_x, pos_y = pos = args[1]
#        from kivy.core.window import Window
#        pos_x = max(0, min(pos_x, Window.width - self._tooltip_wx.width))
#        pos_y = max(0, min(pos_y, Window.height - self._tooltip_wx.height))
#        self._tooltip_wx.pos = (pos_x, pos_y)
#
#        Clock.unschedule(self.display_tooltip) # cancel scheduled event since I moved the cursor
#        self.close_tooltip() # close if it's opened
#        if self.collide_point(*pos):
#            Clock.schedule_once(self.display_tooltip, 1)
#
#    def close_tooltip(self, *args):
#        from kivy.core.window import Window
#        Window.remove_widget(self._tooltip_wx)
#
#    def display_tooltip(self, *args):
#        from kivy.core.window import Window
#        Window.add_widget(self._tooltip_wx)

## EOF ##
