"""

Part of the tagit module.
A copy of the license is provided with the project.
Author: Matthias Baumgartner, 2022
"""
# standard imports
import typing

# tagit imports
from tagit.utils.builder import BuilderBase

# inner-module imports
from .browser_tags import BrowserTags
from .buttons import Buttons
from .cursor_tags import CursorTags
#from .entity_histogram import EntityHistogram
from .geo import Map
from .info import Info
#from .libsummary import LibSummary
#from .searchtree import Searchtree
from .selection_tags import SelectionTags
#from .suggested_tags import SuggestedTags
#from .tag_distribution import TagDistribution
#from .tag_histogram import TagHistogram
#from .tag_tree import TagTree
#from .tagcloud import Tagcloud
#from .venn import Venn

# exports
__all__: typing.Sequence[str] = (
    'TileBuilder',
    )


## code ##

class TileBuilder(BuilderBase):
    _factories = {
        'BrowserTags': BrowserTags,
        'Buttons': Buttons,
        'CursorTags': CursorTags,
#        'EntityHistogram': EntityHistogram,
        'Geo': Map,
        'Info': Info,
#        'LibSummary': LibSummary,
#        'Searchtree': Searchtree,
        'SelectionTags': SelectionTags,
#        'SuggestedTags': SuggestedTags,
#        'TagDistribution': TagDistribution,
#        'TagHistogram': TagHistogram,
#        'TagTree': TagTree,
#        'Tagcloud': Tagcloud,
#        'Venn': Venn,
        }

## EOF ##
