"""

Part of the tagit module.
A copy of the license is provided with the project.
Author: Matthias Baumgartner, 2022

"""
# kivy imports
from kivy.lang import Builder
import kivy.properties as kp

# inner-module imports
from .tile import Tile

# exports
__all__ = ('Buttons', )

## code ##

# load kv
# NOTE: ButtonDock doesn't need to be imported... why?!
Builder.load_string('''
<Buttons>:
    title: 'Actions'
    tooltip: 'Some buttons'

    # content
    slim: False
    btns: btns
    ButtonDock:
        root: root.root
        orientation: 'lr-tb'
        id: btns
        # space between childs
        spacing: (5, 0) if root.slim else (30, 5)
        # space between ButtonDock and its children
        padding: (0, 0) if root.slim else (10, 5)
''')

# classes
class Buttons(Tile):
    """A container for buttons to trigger some action."""
    buttons = kp.ListProperty()

    def update(self):
        if self.visible and len(self.btns.children) == 0:
            self.btns.clear_widgets()
            self.btns.populate(self.buttons)

## EOF ##
