"""

Part of the tagit module.
A copy of the license is provided with the project.
Author: Matthias Baumgartner, 2022
"""
# kivy imports
from kivy.lang import Builder

# tagit imports
from tagit.widgets.browser import BrowserAwareMixin

# inner-module imports
from .tile import TileWithLabel

# exports
__all__ = ('CursorTags', )


## code ##

# load kv
Builder.load_string('''
<CursorTags>:
    title: "Cursor's tags"
    tooltip: 'Tags at the cursor'
''')


# classes
class CursorTags(TileWithLabel, BrowserAwareMixin):
    """Show tags of cursor item."""

    def on_browser(self, sender, browser):
        # remove old binding
        if self.browser is not None:
            self.browser.unbind(cursor=self.update)
        # add new binding
        self.browser = browser
        if self.browser is not None:
            self.browser.bind(cursor=self.update)
            self.update()

    def __del__(self):
        if self.browser is not None:
            self.browser.unbind(cursor=self.update)
            self.browser = None

    def update(self, *args):
        cursor = self.root.browser.cursor
        if not self.visible or cursor is None:
            # no cursor, nothing to do
            self.text = ''
        else:
            tags = cursor.tag.label()
            tags = {tag.title() for tag in tags} # nice display
            tags = sorted(tags)
            self.text = ', '.join(tags)

## EOF ##
