"""

Part of the tagit module.
A copy of the license is provided with the project.
Author: Matthias Baumgartner, 2022
"""
# standard imports
import os
import typing

# kivy imports
from kivy.lang import Builder
from kivy.uix.relativelayout import RelativeLayout
import kivy.properties as kp

# exports
__all__: typing.Sequence[str] = (
    'TileDecorationBorder',
    'TileDecorationRoundedBorder',
    'TileDecorationFilledRectangle',
    'TileDecorationVanilla',
    )


## code ##

# load kv
Builder.load_file(os.path.join(os.path.dirname(__file__), 'decoration.kv'))

# classes
class TileDecoration(RelativeLayout):

    cbox = kp.ObjectProperty(None)
    client = kp.ObjectProperty(None)

    def __repr__(self):
        return f'{self.__class__.__name__}({self.client})'

    def on_cbox(self, wx, cbox):
        if cbox is not None and len(cbox.children) == 0:
            cbox.add_widget(self.client)

    @property
    def default_size(self):
        return self.client.default_size


class TileDecorationVanilla(TileDecoration):
    pass


class TileDecorationFilledRectangle(TileDecoration):
    @property
    def default_size(self):
        width, height = self.client.default_size
        width = None if width is None else width + 10
        height = None if height is None else height + 30
        return width, height


class TileDecorationBorder(TileDecoration):
    @property
    def default_size(self):
        width, height = self.client.default_size
        width = None if width is None else width + 30
        height = None if height is None else height + 30
        return width, height

class TileDecorationRoundedBorder(TileDecoration):
    @property
    def default_size(self):
        width, height = self.client.default_size
        width = None if width is None else width + 30
        height = None if height is None else height + 30
        return width, height

## EOF ##
