"""

Part of the tagit module.
A copy of the license is provided with the project.
Author: Matthias Baumgartner, 2022
"""
# kivy imports
from kivy.lang import Builder

# tagit imports
from tagit.widgets.browser import BrowserAwareMixin

# inner-module imports
from .tile import TileWithLabel

# exports
__all__ = ('SelectionTags', )


## code ##

# load kv
Builder.load_string('''
<SelectionTags>:
    title: "Selection's tags"
    default_size: None, 50
''')

# classes
class SelectionTags(TileWithLabel, BrowserAwareMixin):
    """Show tags of selected items."""

    def on_browser(self, sender, browser):
        # remove old binding
        if self.browser is not None:
            self.browser.unbind(selection=self.update)
        # add new binding
        self.browser = browser
        if self.browser is not None:
            self.browser.bind(selection=self.update)
            self.update()

    def __del__(self):
        if self.browser is not None:
            self.browser.unbind(selection=self.update)
            self.browser = None

    def update(self, *args):
        browser = self.root.browser
        selection = browser.unfold(browser.selection)
        if not self.visible or len(selection) == 0:
            # nothing selected, nothing to do
            self.text = ''
        else:
            tags = selection.tag.label(node=False)
            tags = {tag.title() for tag in tags} # nice display
            tags = sorted(tags)
            self.text = ', '.join(tags)

## EOF ##
