"""

Part of the tagit module.
A copy of the license is provided with the project.
Author: Matthias Baumgartner, 2022
"""
# standard imports
import os

# kivy imports
from kivy.lang import Builder
from kivy.uix.boxlayout import BoxLayout
from kivy.uix.label import Label
from kivy.uix.relativelayout import RelativeLayout
import kivy.properties as kp

# exports
__all__ = ('Tile', 'TileWithLabel', 'TileTabular')


## code ##

# load kv
Builder.load_file(os.path.join(os.path.dirname(__file__), 'tile.kv'))

# classes
class Tile(RelativeLayout):
    visible = kp.BooleanProperty(False)
    root = kp.ObjectProperty(None)

    def on_visible(self, wx, visible):
        if visible:
            self.update()

    def update(self, *args, **kwargs):
        abstract()


class TileWithLabel(Tile):
    pass

class TileTabularRow(BoxLayout):
    pass

class TileTabularCell(Label):
    pass

class TileTabular(Tile):

    tabledata = kp.ObjectProperty()
    keywidth = kp.NumericProperty(0.5)

    def on_tabledata(self, wx, data):
        # set items
        self.rows.clear_widgets()
        for t_key, t_value in data.items():
            # row
            row = TileTabularRow()
            # left column (keys)
            key = TileTabularCell(
                text=t_key,
                halign='right',
                font_size = self.font_size,
                size_hint=(None, 1),
                width=self.width * self.keywidth if self.keywidth < 1 else self.keywidth,
            )
            # right column (values)
            value = TileTabularCell(
                text=str(t_value),
                halign='left',
                font_size = self.font_size,
                size_hint=(1, None),
            )
            # adjust key's width and height dynamically.
            # value's width and height are adjusted automatically
            self.bind(width=lambda wx, width, key=key: setattr(key, 'width',
                width * self.keywidth if self.keywidth < 1 else self.keywidth))
            key.bind(height=lambda wx, height, key=key: setattr(key, 'text_size',
                (key.width, height)))
            # add widgets
            row.add_widget(key)
            row.add_widget(value)
            self.rows.add_widget(row)

## EOF ##
