"""Module-wide errors.

Part of the tagit module.
A copy of the license is provided with the project.
Author: Matthias Baumgartner, 2022
"""
# exports
__all__ = (
    'EmptyFileError',
    'LoaderError',
    'NotAFileError',
    'ProgrammingError',
    'UserError',
    'abstract',
    )


## code ##

def abstract():
    """Marks that a method has to be implemented in a child class."""
    raise NotImplementedError('abstract method that must be implemented in a subclass')

class ProgrammingError(Exception):
    """Reached a program state that shouldn't be reachable."""
    pass

class UserError(ValueError):
    """Found an illegal value that was specified directly by the user."""
    pass

class NotAFileError(OSError):
    """A file-system object is not a regular file."""
    pass

class EmptyFileError(OSError):
    """A file is unexpectedly empty."""
    pass

class LoaderError(Exception):
    """Failed to load or initialize a critical data structure."""
    pass

class ParserFrontendError(Exception):
    """Generic parser frontend error."""
    pass

class ParserBackendError(Exception):
    """Generic parser backend error."""
    pass

class ParserError(Exception):
    """String parsing failure."""
    pass

class BackendError(Exception):
    """Generic backend error."""
    pass

## EOF ##
