"""Default namespaces used throughout tagit.

Part of the tagit module.
A copy of the license is provided with the project.
Author: Matthias Baumgartner, 2022
"""
# standard imports
import typing

# inner-module imports
from . import bsfs as _bsfs

# generic namespaces
xsd = _bsfs.Namespace('http://www.w3.org/2001/XMLSchema')()

# core bsfs namespaces
bsfs = _bsfs.Namespace('https://schema.bsfs.io/core')
bsie = _bsfs.Namespace('https://schema.bsfs.io/ie')

# auxiliary bsfs namespaces
bsn = bsie.Node
bse = bsn.Entity()
bsg = bsn.Group()
bsl = bsfs.Literal
bsp = bsn.Preview()
bst = bsn.Tag()

# export
__all__: typing.Sequence[str] = (
    'bse',
    'bsfs',
    'bsg',
    'bsie',
    'bsl',
    'bsn',
    'bsp',
    'bst',
    'xsd',
    )

## EOF ##
